package org.msh.tb.bd.tbforms.dhis2.tb11;

import org.msh.tb.bd.tbforms.dhis2.DHIS2ExportAsyncTask;
import org.msh.tb.bd.tbforms.dhis2.data.AuthResponse;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.dhis2.data.DataValueResponse;
import org.msh.tb.bd.tbforms.dhis2.tb11.blockbuilders.*;
import org.msh.tb.entities.Tbunit;
import org.msh.utils.date.DateUtils;

/**
 * Created by Mauricio on 17/03/2017.
 * Async task that send TB 11 Information to DHIS2
 */
public class DHIS2ExportTB11AsyncTask extends DHIS2ExportAsyncTask {

    public static final String DHIS2_DATA_SET_ID = "ZdXjoqrMRBT";

    @Override
    protected void execute() {
        try {
            // login into DHIS2
            AuthResponse credentials = dHIS2AuthenticationService.auth();
            this.setProgress(8);

            // Instantiate block builders
            TBForm11Block1Table1Builder block1Table1 = new TBForm11Block1Table1Builder();
            TBForm11Block1Table2Builder block1Table2 = new TBForm11Block1Table2Builder();
            TBForm11Block1Table3Builder block1Table3 = new TBForm11Block1Table3Builder();
            TBForm11Block2Builder block2 = new TBForm11Block2Builder();
            TBForm11Block3TestedBuilder block3Tested = new TBForm11Block3TestedBuilder();
            TBForm11Block3PositiveBuilder block3Positive = new TBForm11Block3PositiveBuilder();
            TBForm11Block3HIVActivitiesBuilder block3Table2 = new TBForm11Block3HIVActivitiesBuilder();

            for (int i = 0; i < tbunits.size(); i++) {
                Tbunit tbunit = tbunits.get(i);

                // instantiate and start to prepare payload
                DataValuePayload payload = new DataValuePayload();
                payload.setDataSet(getFormId());
                payload.setCompleteData(DateUtils.getDate());
                payload.setOrgUnit(tbunit.getDhis2Id());
                payload.setPeriod(selectedQuarter.getDHIS2QuarterCode());

                // get information about blocks in DB and mount it in payload
                block1Table1.buildBlock(tbunit, selectedQuarter, payload);
                block1Table2.buildBlock(tbunit, selectedQuarter, payload);
                block1Table3.buildBlock(tbunit, selectedQuarter, payload);
                block2.buildBlock(tbunit, selectedQuarter, payload);
                block3Tested.buildBlock(tbunit, selectedQuarter, payload);
                block3Positive.buildBlock(tbunit, selectedQuarter, payload);
                block3Table2.buildBlock(tbunit, selectedQuarter, payload);

                // only sends request if dataValues are found.
                if (payload.getDataValues() != null) {

                    // send unit TB 11 Form information
                    DataValueResponse response = dHIS2DataExportService.sendData(credentials, payload);

                    saveTransactionLog(response, tbunit, selectedQuarter);
                }

                // update progress
                double p = 92.0/tbunits.size();
                p = (p*(i+1))+8.0;
                this.setProgress(new Double(p).intValue());
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getFormId() {
        return DHIS2_DATA_SET_ID;
    }

    @Override
    protected String getEventName() {
        return "DHIS2_INTEGRATION_TB11";
    }

    @Override
    public boolean isLogged() {
        return true;
    }
}
